#!/bin/sh


PRG=$0

while [ -h "$PRG" ]; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
    if expr "$link" : '^/' 2> /dev/null >/dev/null; then
        PRG="$link"
    else
        PRG="`dirname "$PRG"`/$link"
    fi
done

MACOS_DIR=`dirname "$PRG"`



JAVA_ROOT="$MACOS_DIR/../Java/jre/Contents/Home/bin"
JAVACMD="$JAVA_ROOT/java"

JAVA_DIR="$MACOS_DIR/../Java"

cd "$JAVA_DIR"


SCRIPT_NAME="$(basename "$0")"

#cut the last three characters off
NAME=${SCRIPT_NAME:0:${#SCRIPT_NAME}-3}

ICON_DIR="$MACOS_DIR/../Resources"

#<string>-Djava.library.path=$APP_ROOT/Contents/Java/lib</string>

exec "$JAVACMD" -classpath "$MACOS_DIR/../Java/*" \
       -Dapple.laf.useScreenMenuBar=false \
       -Dcom.apple.hwaccel=true \
       -Dswing.defaultlaf=com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel \
       -Xdock:name="$NAME" \
       -Xdock:icon="$ICON_DIR/icon.icns" \
       -Xms512m \
       -Xmx1024m \
       com.wibu.xpm.Wrapper



